/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Specifier;
import jade.imtp.leap.ICP;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.JICPPeer;
import jade.mtp.TransportAddress;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.util.Enumeration;
import java.util.Vector;

public class MaskableJICPPeer
extends JICPPeer {
    private Vector masks = new Vector();

    public TransportAddress activate(ICP.Listener l, String peerID, Profile p) throws ICPException {
        try {
            int idLength;
            StringBuffer sb = null;
            if (peerID != null) {
                sb = new StringBuffer(peerID);
                sb.append('-');
                idLength = sb.length();
            } else {
                sb = new StringBuffer();
                idLength = 0;
            }
            sb.append("unreachable");
            List ls = p.getSpecifiers(sb.toString());
            if (ls != null) {
                Iterator it = ls.iterator();
                while (it.hasNext()) {
                    Specifier s = (Specifier)it.next();
                    this.updateMask(s.getClassName());
                }
            }
        }
        catch (ProfileException pe) {
            throw new ICPException("Profile error. " + pe.getMessage());
        }
        return super.activate(l, peerID, p);
    }

    public byte[] deliverCommand(TransportAddress ta, byte[] payload) throws ICPException {
        if (!this.isMasked(ta.getHost())) {
            return super.deliverCommand(ta, payload);
        }
        throw new ICPException("Destination masked");
    }

    private void updateMask(String m) throws ICPException {
        int[] mask = this.parseIP(m);
        this.masks.addElement(mask);
    }

    private boolean isMasked(String host) {
        try {
            int[] ipAddr = this.parseIP(host);
            Enumeration e = this.masks.elements();
            while (e.hasMoreElements()) {
                int[] mask = (int[])e.nextElement();
                boolean masked = true;
                int i = 0;
                while (i < mask.length) {
                    if (ipAddr[i] != mask[i]) {
                        masked = false;
                        break;
                    }
                    ++i;
                }
                if (!masked) continue;
                return true;
            }
            return false;
        }
        catch (ICPException icpe) {
            return false;
        }
    }

    private int[] parseIP(String addr) throws ICPException {
        int[] abcd = new int[4];
        int first = 0;
        int n = 0;
        try {
            boolean stop = false;
            while (n < 3 && !stop) {
                int last = addr.indexOf(46, first);
                if (last < 0) {
                    last = addr.length();
                    stop = true;
                }
                String tmp = addr.substring(first, last);
                abcd[n] = Integer.parseInt(tmp);
                first = last + 1;
                ++n;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (n == 0) {
            throw new ICPException("Wrong mask");
        }
        int[] ipAddr = new int[n];
        int i = 0;
        while (i < n) {
            ipAddr[i] = abcd[i];
            ++i;
        }
        abcd = null;
        return ipAddr;
    }
}

